/* ============ */
/* setprmut.c	*/
/* ============ */
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <miscdefs.h>
#include <pmtndefs.h>
#include <mconf.h>

#define	ACT(X)	#X

#define	CLAMP(Out, Var, Lo, Hi)	Out = __min(Hi, __max(Lo, Var))

#define	NEED_ALL(Label)	"Enter "Label

#define	NEED_USER_ENTRY(LABEL, LO, HI) \
	NEED_ALL(LABEL" ["ACT(LO)"-"ACT(HI)"]: ")

#define	ELEMS_LABEL	"No. Elements Per Permutation"
#define	EXPECT_LABEL	"Expected No. Events for Each Category"

#define	REPORT_USER_INT_ENTRY(Entry, Label)		\
    {							\
	fflush(NULL); printf("\n");			\
	printf("\tNumber Entered:  %.f", (double)Entry);\
	printf(" (%s)\n", Label);			\
    }
#define	SHOW_INT_VALUE_USED(Entered, Used) 			\
	printf("\tTest Value Used: %.f%s\n", (double)Used,	\
	((double)Entered == (double)Used) ? "" : " (Clamped)")

/* ==================================================================== */
/* SetPermuteControls - Puts Run Controls in PermuteData structure	*/
/* ==================================================================== */
void
SetPermuteControls(PRMUT_DATA_STRU  *PermuteData)
{
    int     NewlineCh;
    int     UserIntEntry;

    NewlineCh = _isatty(_fileno(stdin)) ? '\r' : '\n';

    /* ------------------------------------------------- */
    /* Get Number of Variates (Elements) Per Permutation */
    /* ------------------------------------------------- */
    GetInt(NEED_USER_ENTRY(ELEMS_LABEL, MIN_ELEMS, MAX_ELEMS),
	&UserIntEntry);

    REPORT_USER_INT_ENTRY(UserIntEntry, ELEMS_LABEL);

    /* ---------------------------------------- */
    /* Clamp Number of Elements Per Permutation */
    /* ---------------------------------------- */
    CLAMP(PermuteData->NumElements, UserIntEntry, MIN_ELEMS, MAX_ELEMS);

    SHOW_INT_VALUE_USED(UserIntEntry, PermuteData->NumElements);

    fflush(NULL); fprintf(stderr, "%c", NewlineCh);
    /* ------------------------------------------- */
    /* Calculate Number of Categories in This Test */
    /* ------------------------------------------- */
    PermuteData->NumCategories = (int) fac(PermuteData->NumElements);

    printf("%6d  CATEGORIES IN THIS TEST\n", PermuteData->NumCategories);

    /* ------------------------ */
    /* Request Cell Expectation	*/
    /* ------------------------ */
    GetInt(NEED_USER_ENTRY(EXPECT_LABEL, MIN_CELL_CT, MAX_CELL_CT),
	&UserIntEntry);

    REPORT_USER_INT_ENTRY(UserIntEntry, EXPECT_LABEL);

    /* ---------------------- */
    /* Clamp Cell Expectation */
    /* ---------------------- */
    CLAMP(PermuteData->CellExpectation, UserIntEntry, MIN_CELL_CT,
	MAX_CELL_CT);

    SHOW_INT_VALUE_USED(UserIntEntry, PermuteData->CellExpectation);

    fflush(NULL); fprintf(stderr, "%c", NewlineCh);
    /* ----------------------------------------------- */
    /* Calculate Number of Permutations to be Analyzed */
    /* ----------------------------------------------- */
    PermuteData->NumObs = (UINT)
	PermuteData->CellExpectation * PermuteData->NumCategories;

    printf("%6u  OBSERVATIONS (PERMUTATIONS) WILL BE ANALYZED\n",
	PermuteData->NumObs);
}
